# Relayer API Test Utils

This directory contains utilities for testing the Relayer API.

Requires `ethers` v6, `ethers-decode-error` v2, and `tweetnacl` v1 packages to be installed in the project.

## API

### `createKeyPair.ts`

Exports a function to create an ed25519 key pair.

### `createKeyPairCLI.ts`

CLI to create an ed25519 key pair.

Usage:

```bash
ts-node test/utils/api/createKeypairCLI.ts
```

### `createReqSignature.ts`

Exports a function to create a signature for a given request.

### `createReqSignatureCLI.ts`

CLI to create a signature for a given request.

Usage:

```bash
$ ts-node test/utils/api/createReqSignatureCLI.ts '{"test": "1"}' ED_25519_SECRET_IN_BASE64

X-Request-Pk-B64: PQ3Kum2dI+mnMIRBCLB5Nb1zYKvUwY19JG36gsNYx6s=
X-Request-Sig-B64: KFmp93bXB9V8EMER1uvr4n7l9Jy3krXkmyJRgfZuMkzPK+ggzM2xW4fmpJuCtpP0tTyetSFukg9kkMLJBkSDQ==
```

## CMKV5 Transactions

### `createTxData.ts`

Exports a set of functions to create a transaction data payload for a given function call.

### `createMetaTx.ts`

Exports a function to create a meta transaction for a given data payload.

### `createMetaTxCLI.ts`

CLI to create an ERC2771 meta transaction for a given function call.

Usage:

```bash
$ ts-node test/utils/cmkv5/transactions/createMetaTxCLI.ts setIdentity 0x42D00fC2Efdace4859187DE4865Df9BaA320D5dB,1,2,3,4,true 0x42D00fC2Efdace4859187DE4865Df9BaA320D5dB 0xF4258B3415Cab41Fc9cE5f9b159Ab21ede0501B1 1 SIGNER_PRIVATE_KEY

{
  from: '0x941AcAF215DA12A8c72d8d7659Df8073Ed6C6f60',
  to: '0x42D00fC2Efdace4859187DE4865Df9BaA320D5dB',
  value: 0,
  gas: 1000000,
  nonce: 1757435856984,
  deadline: 0,
  data: '0x3b3f378000000000000000000000000042d00fc2efdace4859187de4865df9baa320d5db000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000a0000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000030000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001',
  signature: '0x0d79e99b5cadd556d8db6f96a3cbe81bc7d80e83903653098ca0b1243855d93a49085cd8d50d3f61b9e178f8fcbad015223e0ab6ab8e1b07a375871906b2a1251b'
}
```
